<?php include 'header.php'; ?>
<?php
$msg = '';

// Fetch current settings
$settings = null;
$stmt = $conn->prepare("SELECT * FROM upwork_settings WHERE user_id = ? LIMIT 1");
$stmt->bind_param("s", $userId);
if ($stmt->execute()) {
    $res = $stmt->get_result();
    if ($res && $res->num_rows === 1) {
        $settings = $res->fetch_assoc();
    }
}
$stmt->close();

// Defaults
$default_price_percentage = "90";

// Current value
$current_price_percentage = $default_price_percentage;
if ($settings && isset($settings['price_percentage']) && $settings['price_percentage'] !== null && $settings['price_percentage'] !== '') {
    $current_price_percentage = (string)$settings['price_percentage'];
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $price_percentage = isset($_POST['price_percentage']) ? trim($_POST['price_percentage']) : $default_price_percentage;
    if ($price_percentage === '') {
        $price_percentage = $default_price_percentage;
    }

    // Sanitize to 0-100
    if (is_numeric($price_percentage)) {
        $num = (int)$price_percentage;
        if ($num < 0) { $num = 0; }
        if ($num > 100) { $num = 100; }
        $price_percentage = (string)$num;
    } else {
        $price_percentage = $default_price_percentage;
    }

    if ($settings) {
        $query = "UPDATE upwork_settings SET price_percentage = ?, updated_at = NOW() WHERE user_id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("ss", $price_percentage, $userId);
        if ($stmt->execute()) {
            $msg = '<div class="alert alert-success alert-top-border alert-dismissible fade show" role="alert">
                        <i class="ri-check-double-line me-3 align-middle fs-16 text-success"></i><strong>Success</strong> - Price settings updated
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>';
            $current_price_percentage = $price_percentage;
        } else {
            $msg = '<div class="alert alert-danger alert-top-border alert-dismissible fade show" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16 text-danger"></i><strong>Error</strong> - Failed to update settings
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>';
        }
        $stmt->close();
    } else {
        $query = "INSERT INTO upwork_settings (user_id, price_percentage, created_at, updated_at) VALUES (?, ?, NOW(), NOW())";
        $stmt = $conn->prepare($query);
        $stmt->bind_param("ss", $userId, $price_percentage);
        if ($stmt->execute()) {
            $msg = '<div class="alert alert-success alert-top-border alert-dismissible fade show" role="alert">
                        <i class="ri-check-double-line me-3 align-middle fs-16 text-success"></i><strong>Success</strong> - Price settings saved
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>';
            $current_price_percentage = $price_percentage;
        } else {
            $msg = '<div class="alert alert-danger alert-top-border alert-dismissible fade show" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16 text-danger"></i><strong>Error</strong> - Failed to save settings
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>';
        }
        $stmt->close();
    }
}
?>

<div class="page-content">
    <div class="container-fluid">

        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">
                    <h4 class="mb-sm-0">Price Settings</h4>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item active">Price</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <center>
            <div class="col-lg-6">
                <?php echo $msg; ?>

                <div class="card card-body text-center">
                    <div class="avatar-xl mx-auto mb-3 mt-4">
                        <div class="avatar-title bg-transparent text-success rounded" style="font-size: 100px">
                            <i class="ri-price-tag-3-line"></i>
                        </div>
                    </div>
                    <h2>Bid Price</h2>
                    <p class="card-text text-muted">Configure pricing preferences for job bidding.</p>

                    <form method="POST" class="p-4 text-start">
                        <div class="mb-4">
                            <label class="form-label" for="price_percentage">Price Percentage</label>
                            <input type="number" min="0" max="100" step="1" class="form-control" id="price_percentage" name="price_percentage" value="<?php echo htmlspecialchars($current_price_percentage); ?>" placeholder="e.g. 90">
                            <div class="form-text">Percentage of listed budget to bid. 0 - 100.</div>
                        </div>

                        <button type="submit" class="btn btn-success w-100">Save settings</button>
                    </form>
                </div>
            </div>
        </center>
    </div>

    <?php include 'footer.php'; ?>

<?php include 'header.php'; ?>
<?php
$msg='';

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
$percentage = $_POST['percentage'];

$query = "UPDATE bid_price SET percentage = '$percentage' WHERE user_id = '$userId'";
if ($conn->query($query) === TRUE) {
     $msg = '<div class="alert alert-success alert-top-border alert-dismissible fade show" role="alert">
                    <i class="ri-check-double-line me-3 align-middle fs-16 text-success"></i><strong>Success</strong> - Project Budget settings updated
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>';
} else {
      $msg = '<div class="alert alert-danger alert-top-border alert-dismissible fade show" role="alert">
                    <i class="ri-error-warning-line me-3 align-middle fs-16 text-danger"></i><strong>Error</strong> - Settings updation error
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>';
}
    
}

$sql = "SELECT * FROM bid_price WHERE user_id='$userId'";
$result = $conn->query($sql);

if ($result->num_rows == 1) {
    $bprow = $result->fetch_assoc();
}
?>
<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">
                    <h4 class="mb-sm-0">Bid Price</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item active">Bid Price</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        <center>

            <div class="col-lg-6">
                <?php echo $msg; ?>
                <div class="card card-body text-center">

                    <h2>Bid Price</h2>
<p>For custom budgets and ranges without fixed price</p>


                    <form method="POST" class="p-4">

                        <div class="row row-cols-lg-auto align-items-center g-3 justify-content-center">


                            <div class="mb-2">
                                <label class="float-start" for="percentage">% of Max Budget</label>
                                <input type="number" class="form-control" id="percentage" name="percentage" value="<?php echo $bprow['percentage']; ?>" min="25" max="100">
                            </div>


                        </div>
                        <!--end row-->
                        <button type="submit" class="btn btn-success mt-4 w-100">Submit</button>
                    </form>
                </div>
            </div>





        </center>
        <!-- container-fluid -->
    </div>

    <?php include 'footer.php'; ?>