<?php  
include 'login-check.php';
include 'header.php';
?>

<?php 
// Load Upwork credentials
$upworkCreds = null;
$stmt = $conn->prepare("SELECT * FROM upwork WHERE user_id = ? LIMIT 1");
$stmt->bind_param("s", $userId);
if ($stmt->execute()) {
    $res = $stmt->get_result();
    if ($res && $res->num_rows === 1) {
        $upworkCreds = $res->fetch_assoc();
    }
}
$stmt->close();

// Get greeting based on current hour
function getGreeting() {
    $currentHour = date('H');
    if ($currentHour >= 5 && $currentHour < 12) {
        return "Good morning";
    } else if ($currentHour >= 12 && $currentHour < 18) {
        return "Good afternoon";
    } else if ($currentHour >= 18 && $currentHour < 22) {
        return "Good evening";
    } else {
        return "Good night";
    }
}

$greeting = getGreeting();
?>
<div class="page-content">
        
   
                 
                
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">
                    <h4 class="mb-sm-0">Home</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item active">Home</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
   
        <div class="row">
            <div class="col-xxl-6">
                <div class="d-flex flex-column h-100">
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
							<div class="card-body">
                        <div class="p-6 rounded-md text-black">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <h2 class="text-2xl font-semibold mb-3">
                                        <?php echo $greeting; ?> 
                                        <a href="#" id="profileLink" target="_blank" rel="noopener noreferrer" class="text-success text-decoration-underline">
                                            <span id="userName">Loading...</span>
                                        </a>
                                    </h2>
                                    <p class="font-medium text-muted mb-2" id="userTitle">Loading...</p>
                                    <p class="text-sm text-muted mb-3">Get started to rise on Upwork</p>

                                    <div class="mt-2 mb-3">
                                        <span class="px-2 py-1 rounded text-xs font-medium bg-success bg-opacity-10 text-success mb-0" id="connectsBadge" >
                                            Connects: <span id="connectsBalance">...</span>
                                        </span>
                                    </div>
                                   
                                </div>
                                <div class="flex-shrink-0">
                                    <img src="<?php echo $pp; ?>" alt="user" id="profileImage" class="w-24 h-24 object-cover rounded-circle" />
                                </div>
                            </div>
                        </div>


                        <!-- Error Message -->
                        <div id="errorMessage" class="alert alert-danger" style="display: none;">
                            <span id="errorText"></span>
                        </div>
                    </div>
                            </div>
                        </div> <!-- end col-->
                    </div> <!-- end row-->
                    <script>
const upworkCreds = <?php echo json_encode($upworkCreds); ?>;
</script>

<!-- Include profile.js -->
<script src="profilejs.php"></script>
                    <?php
// Assuming $conn is your database connection object

// Get today's date and the first day of the current month
$today = date('Y-m-d');
$firstDayOfMonth = date('Y-m-01');

// Query to count rows where user_id = $userId and time column date is today
$sqlToday = "SELECT COUNT(*) AS num_rows_today FROM upwork_bids_history WHERE user_id = '$userId' AND DATE(time) = '$today'";
$resultToday = $conn->query($sqlToday);
$rowToday = $resultToday->fetch_assoc();
$numRowsToday = $rowToday['num_rows_today'];

// Query to count rows where user_id = $userId and time column date is within the current month
$sqlMonth = "SELECT COUNT(*) AS num_rows_month FROM upwork_bids_history WHERE user_id = '$userId' AND DATE(time) >= '$firstDayOfMonth'";
$resultMonth = $conn->query($sqlMonth);
$rowMonth = $resultMonth->fetch_assoc();
$numRowsMonth = $rowMonth['num_rows_month'];

?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Bids</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value"
                                                    data-target="<?php echo $numRowsToday; ?>">0</span> Bids</h2>
                                            <p class="mb-0 text-muted"><span
                                                    class="badge bg-light text-success mb-0">Today
                                                </span></p>
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-primary-subtle rounded-circle fs-16">
                                                    <i class="ri-auction-fill text-primary"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div> <!-- end card-->
                        </div> <!-- end col-->

                        <div class="col-md-6">
                            <div class="card card-animate">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between">
                                        <div>
                                            <p class="fw-medium text-muted mb-0">Bids</p>
                                            <h2 class="mt-4 ff-secondary fw-semibold"><span class="counter-value"
                                                    data-target="<?php echo $numRowsMonth; ?>">0</span> Bids</h2>
                                            <p class="mb-0 text-muted"><span
                                                    class="badge bg-light text-warning mb-0">This month
                                                </span></p>
                                        </div>
                                        <div>
                                            <div class="avatar-sm flex-shrink-0">
                                                <span class="avatar-title bg-primary-subtle rounded-circle fs-16">
                                                <i class="ri-auction-fill text-primary"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div><!-- end card body -->
                            </div> <!-- end card-->
                        </div> <!-- end col-->
                    </div> <!-- end row-->

                </div>
            </div> <!-- end col-->

            <div class="col-xxl-6">

                <div class="row h-100">

                   
                        <div class="card">
                            <div class="card-body">
                                <div id="line_chart_basic" data-colors='["--vz-primary"]' class="apex-charts" dir="ltr">
                                </div>
                            </div><!-- end card-body -->
                        </div><!-- end card -->


                </div> <!-- end row-->
            </div><!-- end col -->
        </div> <!-- end row-->

        <div class="">
            <h5>Recent Bids</h5>
    
            <?php
            // Load last 5 bids from upwork_bids_history
            $stmt = $conn->prepare("SELECT * FROM upwork_bids_history WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
            $stmt->bind_param("s", $userId);
            if ($stmt->execute()) {
                $res = $stmt->get_result();
                if ($res && $res->num_rows > 0) {
                    while ($bid = $res->fetch_assoc()) {
                        $client = json_decode($bid['client'], true);
                        $skills = json_decode($bid['skills'], true);
                        $timeAgo = getTimeAgo($bid['created_at']);
                        ?>
                        <div class="card mb-3" style="border-radius: 10px;">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <div class="flex-grow-1">
                                        <h6 class="card-title mb-1">
                                            <a href="https://www.upwork.com/jobs/<?php echo htmlspecialchars($bid['jcipher']); ?>/" target="_blank" rel="noopener noreferrer" class="text-decoration-none">
                                                <?php echo htmlspecialchars($bid['jtitle']); ?>
                                            </a>
                                        </h6>
                                        <div class="text-muted" style="font-size: 10px;">
                                            Bid submitted <?php echo $timeAgo; ?>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <?php if ($client && $client['paymentVerificationStatus'] === 'VERIFIED'): ?>
                                            <span class="badge bg-success" style="font-size: 10px;"><i class="ri-verified-badge-line me-1" style="font-size: 12px;"></i>Payment Verified</span>
                                        <?php endif; ?>
                                        <a href="https://www.upwork.com/jobs/<?php echo htmlspecialchars($bid['jcipher']); ?>/" target="_blank" rel="noopener noreferrer" class="p-2">
                                            <i class="ri-external-link-line" style="font-size: 14px;"></i>
                                        </a>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <div class="d-flex align-items-center gap-3">
                                            <?php if ($client && isset($client['totalReviews'])): ?>
                                                <div class="d-flex align-items-center mt-2">
                                                    <?php 
                                                    $rating = $client['totalFeedback'] ?? 0;
                                                    for ($i = 0; $i < 5; $i++): 
                                                        $starClass = $i < $rating ? 'ri-star-fill text-warning' : 'ri-star-fill text-muted';
                                                    ?>
                                                        <i class="<?php echo $starClass; ?>" style="font-size: 16px;"></i>
                                                    <?php endfor; ?>
                                                    <small class="text-muted ms-1" style="font-size: 14px;">(<?php echo $client['totalReviews'] ?? 0; ?>)</small>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($client && isset($client['country'])): ?>
                                                <div class="text-muted" style="font-size: 14px;">
                                                    <i class="ri-map-pin-line me-1"></i>
                                                    <?php echo htmlspecialchars($client['country']); ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6 text-end">
                                        <?php if ($client && isset($client['totalSpent']['amount'])): ?>
                                            <div class="text-muted" style="font-size: 14px;">
                                                <?php echo number_format($client['totalSpent']['amount']); ?> <?php echo $client['totalSpent']['isoCurrencyCode']; ?> spent
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="mb-2">
                                    <div class="d-flex align-items-center gap-3">
                                        <?php if ($bid['jobType']): ?>
                                            <span class="badge bg-secondary" style="font-size: 10px;"><?php echo htmlspecialchars($bid['jobType']); ?></span>
                                        <?php endif; ?>
                                        <?php if ($bid['jprice']): ?>
                                            <span class="badge bg-info" style="font-size: 10px;"><?php echo htmlspecialchars($bid['jprice']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <?php if ($bid['description']): ?>
                                    <div class="card-text mb-4" style="font-size: 12px; line-height: 1.4;">
                                        <?php echo htmlspecialchars(substr($bid['description'], 0, 200)) . (strlen($bid['description']) > 200 ? '...' : ''); ?>
                                    </div>
                                <?php endif; ?>

                                <?php if ($skills && is_array($skills) && count($skills) > 0): ?>
                                    <div class="mb-3">
                                        <div class="d-flex flex-wrap gap-1">
                                            <?php foreach (array_slice($skills, 0, 5) as $skill): ?>
                                                <span class="badge bg-success" style="font-size: 10px;"><?php echo htmlspecialchars($skill); ?></span>
                                            <?php endforeach; ?>
                                            <?php if (count($skills) > 5): ?>
                                                <span class="badge bg-secondary" style="font-size: 10px;">+<?php echo count($skills) - 5; ?> more</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <small class="text-muted">Bid Amount: <strong>$<?php echo htmlspecialchars($bid['price']); ?></strong></small>
                                    </div>
                                    <div>
                                        <div class="text-success" style="font-size: 16px; font-weight: 600; text-align: center; padding: 10px;">
                                            Applied
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    echo '<div class="text-center py-4">
                        <i class="ri-file-list-line" style="font-size: 48px; color: #6c757d;"></i>
                        <h6 class="mt-3">No Bids Found</h6>
                        <p class="text-muted">You haven\'t submitted any bids yet.</p>
                        <a href="search.php" class="btn btn-primary btn-sm">Start Searching</a>
                    </div>';
                }
            }
            $stmt->close();
            
            function getTimeAgo($datetime) {
                $time = time() - strtotime($datetime);
                
                if ($time < 60) return 'just now';
                if ($time < 3600) return floor($time/60) . ' minutes ago';
                if ($time < 86400) return floor($time/3600) . ' hours ago';
                if ($time < 2592000) return floor($time/86400) . ' days ago';
                if ($time < 31536000) return floor($time/2592000) . ' months ago';
                return floor($time/31536000) . ' years ago';
            }
            ?>
        </div>
        <!-- end table responsive -->


    </div>
    <!-- container-fluid -->
</div>

<?php

$data = array();
$date = date('Y-m-d', strtotime('-6 days')); // Get date 7 days ago (inclusive of today)
$sql = "SELECT DATE(time) AS date, COUNT(*) AS num_bids FROM upwork_bids_history WHERE user_id = '$userId' AND DATE(time) >= '$date' GROUP BY DATE(time)";
$result = $conn->query($sql);

if ($result !== false && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[$row['date']] = $row['num_bids'];
    }
}

// Format data for JavaScript
$categories = array();
$bidCounts = array();
$currentDate = strtotime('-6 days');
for ($i = 0; $i < 7; $i++) {
    $date = date('Y-m-d', $currentDate);
    $categories[] = date('d M', $currentDate);
    $bidCounts[] = isset($data[$date]) ? $data[$date] : 0;
    $currentDate = strtotime('+1 day', $currentDate);
}

// Encode data as JSON
$categoriesJSON = json_encode($categories);
$bidCountsJSON = json_encode($bidCounts);

?>



<script src="assets/libs/apexcharts/apexcharts.min.js"></script>

<script>
    
function getChartColorsArray(e)
{
	if (null !== document.getElementById(e))
	{
		e = document.getElementById(e).getAttribute("data-colors");
		if (e) return (e = JSON.parse(e)).map(function(e)
		{
			var t = e.replace(" ", "");
			return -1 === t.indexOf(",") ? getComputedStyle(document.documentElement).getPropertyValue(t) || t : 2 == (e = e.split(",")).length ? "rgba(" + getComputedStyle(document.documentElement).getPropertyValue(e[0]) + "," + e[1] + ")" : t
		})
	}
}
var linechartBasicColors = getChartColorsArray("line_chart_basic")
	, linechartZoomColors = (linechartBasicColors && (options = {
		series: [
		{
			name: "Bids"
			, data: <?php echo $bidCountsJSON; ?>
		}]
		, chart:
		{
			height: 350
			, type: "line"
			, zoom:
			{
				enabled: !1
			}
			, toolbar:
			{
				show: !1
			}
		}
		, markers:
		{
			size: 4
		}
		, dataLabels:
		{
			enabled: !1
		}
		, stroke:
		{
			curve: "straight"
		}
		, colors: linechartBasicColors
		, title:
		{
			text: "Bids Last 7 Days"
			, align: "left"
			, style:
			{
				fontWeight: 500
			}
		}
		, xaxis:
		{
			categories: <?php echo $categoriesJSON; ?>
		}
	}, (chart = new ApexCharts(document.querySelector("#line_chart_basic"), options)).render()), getChartColorsArray("line_chart_zoomable"))
	, linechartDatalabelColors = (linechartZoomColors && (options = {
		series: [
		{
			name: "XYZ MOTORS"
			, data: [
			{
				x: new Date("2018-01-12").getTime()
				, y: 140
			}
			, {
				x: new Date("2018-01-13").getTime()
				, y: 147
			}
			, {
				x: new Date("2018-01-14").getTime()
				, y: 150
			}
			, {
				x: new Date("2018-01-15").getTime()
				, y: 154
			}
			, {
				x: new Date("2018-01-16").getTime()
				, y: 160
			}
			, {
				x: new Date("2018-01-17").getTime()
				, y: 165
			}
			, {
				x: new Date("2018-01-18").getTime()
				, y: 162
			}
			, {
				x: new Date("2018-01-20").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-01-21").getTime()
				, y: 164
			}
			, {
				x: new Date("2018-01-22").getTime()
				, y: 160
			}
			, {
				x: new Date("2018-01-23").getTime()
				, y: 165
			}
			, {
				x: new Date("2018-01-24").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-01-25").getTime()
				, y: 172
			}
			, {
				x: new Date("2018-01-26").getTime()
				, y: 177
			}
			, {
				x: new Date("2018-01-27").getTime()
				, y: 173
			}
			, {
				x: new Date("2018-01-28").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-01-29").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-01-30").getTime()
				, y: 158
			}
			, {
				x: new Date("2018-02-01").getTime()
				, y: 153
			}
			, {
				x: new Date("2018-02-02").getTime()
				, y: 149
			}
			, {
				x: new Date("2018-02-03").getTime()
				, y: 144
			}
			, {
				x: new Date("2018-02-05").getTime()
				, y: 150
			}
			, {
				x: new Date("2018-02-06").getTime()
				, y: 155
			}
			, {
				x: new Date("2018-02-07").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-02-08").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-02-09").getTime()
				, y: 156
			}
			, {
				x: new Date("2018-02-11").getTime()
				, y: 151
			}
			, {
				x: new Date("2018-02-12").getTime()
				, y: 157
			}
			, {
				x: new Date("2018-02-13").getTime()
				, y: 161
			}
			, {
				x: new Date("2018-02-14").getTime()
				, y: 150
			}
			, {
				x: new Date("2018-02-15").getTime()
				, y: 154
			}
			, {
				x: new Date("2018-02-16").getTime()
				, y: 160
			}
			, {
				x: new Date("2018-02-17").getTime()
				, y: 165
			}
			, {
				x: new Date("2018-02-18").getTime()
				, y: 162
			}
			, {
				x: new Date("2018-02-20").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-02-21").getTime()
				, y: 164
			}
			, {
				x: new Date("2018-02-22").getTime()
				, y: 160
			}
			, {
				x: new Date("2018-02-23").getTime()
				, y: 165
			}
			, {
				x: new Date("2018-02-24").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-02-25").getTime()
				, y: 172
			}
			, {
				x: new Date("2018-02-26").getTime()
				, y: 177
			}
			, {
				x: new Date("2018-02-27").getTime()
				, y: 173
			}
			, {
				x: new Date("2018-02-28").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-02-29").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-02-30").getTime()
				, y: 162
			}
			, {
				x: new Date("2018-03-01").getTime()
				, y: 158
			}
			, {
				x: new Date("2018-03-02").getTime()
				, y: 152
			}
			, {
				x: new Date("2018-03-03").getTime()
				, y: 147
			}
			, {
				x: new Date("2018-03-05").getTime()
				, y: 142
			}
			, {
				x: new Date("2018-03-06").getTime()
				, y: 147
			}
			, {
				x: new Date("2018-03-07").getTime()
				, y: 151
			}
			, {
				x: new Date("2018-03-08").getTime()
				, y: 155
			}
			, {
				x: new Date("2018-03-09").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-03-11").getTime()
				, y: 162
			}
			, {
				x: new Date("2018-03-12").getTime()
				, y: 157
			}
			, {
				x: new Date("2018-03-13").getTime()
				, y: 161
			}
			, {
				x: new Date("2018-03-14").getTime()
				, y: 166
			}
			, {
				x: new Date("2018-03-15").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-03-16").getTime()
				, y: 172
			}
			, {
				x: new Date("2018-03-17").getTime()
				, y: 177
			}
			, {
				x: new Date("2018-03-18").getTime()
				, y: 181
			}
			, {
				x: new Date("2018-03-20").getTime()
				, y: 178
			}
			, {
				x: new Date("2018-03-21").getTime()
				, y: 173
			}
			, {
				x: new Date("2018-03-22").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-03-23").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-03-24").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-03-25").getTime()
				, y: 164
			}
			, {
				x: new Date("2018-03-26").getTime()
				, y: 168
			}
			, {
				x: new Date("2018-03-27").getTime()
				, y: 172
			}
			, {
				x: new Date("2018-03-28").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-03-29").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-03-30").getTime()
				, y: 162
			}
			, {
				x: new Date("2018-04-01").getTime()
				, y: 158
			}
			, {
				x: new Date("2018-04-02").getTime()
				, y: 152
			}
			, {
				x: new Date("2018-04-03").getTime()
				, y: 147
			}
			, {
				x: new Date("2018-04-05").getTime()
				, y: 142
			}
			, {
				x: new Date("2018-04-06").getTime()
				, y: 147
			}
			, {
				x: new Date("2018-04-07").getTime()
				, y: 151
			}
			, {
				x: new Date("2018-04-08").getTime()
				, y: 155
			}
			, {
				x: new Date("2018-04-09").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-04-11").getTime()
				, y: 162
			}
			, {
				x: new Date("2018-04-12").getTime()
				, y: 157
			}
			, {
				x: new Date("2018-04-13").getTime()
				, y: 161
			}
			, {
				x: new Date("2018-04-14").getTime()
				, y: 166
			}
			, {
				x: new Date("2018-04-15").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-04-16").getTime()
				, y: 172
			}
			, {
				x: new Date("2018-04-17").getTime()
				, y: 177
			}
			, {
				x: new Date("2018-04-18").getTime()
				, y: 181
			}
			, {
				x: new Date("2018-04-20").getTime()
				, y: 178
			}
			, {
				x: new Date("2018-04-21").getTime()
				, y: 173
			}
			, {
				x: new Date("2018-04-22").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-04-23").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-04-24").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-04-25").getTime()
				, y: 164
			}
			, {
				x: new Date("2018-04-26").getTime()
				, y: 168
			}
			, {
				x: new Date("2018-04-27").getTime()
				, y: 172
			}
			, {
				x: new Date("2018-04-28").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-04-29").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-04-30").getTime()
				, y: 162
			}
			, {
				x: new Date("2018-05-01").getTime()
				, y: 158
			}
			, {
				x: new Date("2018-05-02").getTime()
				, y: 152
			}
			, {
				x: new Date("2018-05-03").getTime()
				, y: 147
			}
			, {
				x: new Date("2018-05-04").getTime()
				, y: 142
			}
			, {
				x: new Date("2018-05-05").getTime()
				, y: 147
			}
			, {
				x: new Date("2018-05-07").getTime()
				, y: 151
			}
			, {
				x: new Date("2018-05-08").getTime()
				, y: 155
			}
			, {
				x: new Date("2018-05-09").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-05-11").getTime()
				, y: 162
			}
			, {
				x: new Date("2018-05-12").getTime()
				, y: 157
			}
			, {
				x: new Date("2018-05-13").getTime()
				, y: 161
			}
			, {
				x: new Date("2018-05-14").getTime()
				, y: 166
			}
			, {
				x: new Date("2018-05-15").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-05-16").getTime()
				, y: 172
			}
			, {
				x: new Date("2018-05-17").getTime()
				, y: 177
			}
			, {
				x: new Date("2018-05-18").getTime()
				, y: 181
			}
			, {
				x: new Date("2018-05-20").getTime()
				, y: 178
			}
			, {
				x: new Date("2018-05-21").getTime()
				, y: 173
			}
			, {
				x: new Date("2018-05-22").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-05-23").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-05-24").getTime()
				, y: 159
			}
			, {
				x: new Date("2018-05-25").getTime()
				, y: 164
			}
			, {
				x: new Date("2018-05-26").getTime()
				, y: 168
			}
			, {
				x: new Date("2018-05-27").getTime()
				, y: 172
			}
			, {
				x: new Date("2018-05-28").getTime()
				, y: 169
			}
			, {
				x: new Date("2018-05-29").getTime()
				, y: 163
			}
			, {
				x: new Date("2018-05-30").getTime()
				, y: 162
			}]
		}]
		, chart:
		{
			type: "area"
			, stacked: !1
			, height: 350
			, zoom:
			{
				type: "x"
				, enabled: !0
				, autoScaleYaxis: !0
			}
			, toolbar:
			{
				autoSelected: "zoom"
			}
		}
		, colors: linechartZoomColors
		, dataLabels:
		{
			enabled: !1
		}
		, markers:
		{
			size: 0
		}
		, title:
		{
			text: "Stock Price Movement"
			, align: "left"
			, style:
			{
				fontWeight: 500
			}
		}
		, fill:
		{
			type: "gradient"
			, gradient:
			{
				shadeIntensity: 1
				, inverseColors: !1
				, opacityFrom: .5
				, opacityTo: 0
				, stops: [0, 90, 100]
			}
		}
		, yaxis:
		{
			showAlways: !0
			, labels:
			{
				show: !0
				, formatter: function(e)
				{
					return (e / 1e6).toFixed(0)
				}
			}
			, title:
			{
				text: "Price"
				, style:
				{
					fontWeight: 500
				}
			}
		}
		, xaxis:
		{
			type: "datetime"
		}
		, tooltip:
		{
			shared: !1
			, y:
			{
				formatter: function(e)
				{
					return (e / 1e6).toFixed(0)
				}
			}
		}
	}, (chart = new ApexCharts(document.querySelector("#line_chart_zoomable"), options)).render()), getChartColorsArray("line_chart_datalabel"))
	, linechartDashedColors = (linechartDatalabelColors && (options = {
		chart:
		{
			height: 380
			, type: "line"
			, zoom:
			{
				enabled: !1
			}
			, toolbar:
			{
				show: !1
			}
		}
		, colors: linechartDatalabelColors
		, dataLabels:
		{
			enabled: !1
		}
		, stroke:
		{
			width: [3, 3]
			, curve: "straight"
		}
		, series: [
		{
			name: "High - 2018"
			, data: [26, 24, 32, 36, 33, 31, 33]
		}
		, {
			name: "Low - 2018"
			, data: [14, 11, 16, 12, 17, 13, 12]
		}]
		, title:
		{
			text: "Average High & Low Temperature"
			, align: "left"
			, style:
			{
				fontWeight: 500
			}
		}
		, grid:
		{
			row:
			{
				colors: ["transparent", "transparent"]
				, opacity: .2
			}
			, borderColor: "#f1f1f1"
		}
		, markers:
		{
			style: "inverted"
			, size: 6
		}
		, xaxis:
		{
			categories: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul"]
			, title:
			{
				text: "Month"
			}
		}
		, yaxis:
		{
			title:
			{
				text: "Temperature"
			}
			, min: 5
			, max: 40
		}
		, legend:
		{
			position: "top"
			, horizontalAlign: "right"
			, floating: !0
			, offsetY: -25
			, offsetX: -5
		}
		, responsive: [
		{
			breakpoint: 600
			, options:
			{
				chart:
				{
					toolbar:
					{
						show: !1
					}
				}
				, legend:
				{
					show: !1
				}
			}
		}]
	}, (chart = new ApexCharts(document.querySelector("#line_chart_datalabel"), options)).render()), getChartColorsArray("line_chart_dashed"))
	, linechartannotationsColors = (linechartDashedColors && (options = {
		chart:
		{
			height: 380
			, type: "line"
			, zoom:
			{
				enabled: !1
			}
			, toolbar:
			{
				show: !1
			}
		}
		, colors: linechartDashedColors
		, dataLabels:
		{
			enabled: !1
		}
		, stroke:
		{
			width: [3, 4, 3]
			, curve: "straight"
			, dashArray: [0, 8, 5]
		}
		, series: [
		{
			name: "Session Duration"
			, data: [45, 52, 38, 24, 33, 26, 21, 20, 6, 8, 15, 10]
		}
		, {
			name: "Page Views"
			, data: [36, 42, 60, 42, 13, 18, 29, 37, 36, 51, 32, 35]
		}
		, {
			name: "Total Visits"
			, data: [89, 56, 74, 98, 72, 38, 64, 46, 84, 58, 46, 49]
		}]
		, title:
		{
			text: "Page Statistics"
			, align: "left"
			, style:
			{
				fontWeight: 500
			}
		}
		, markers:
		{
			size: 0
			, hover:
			{
				sizeOffset: 6
			}
		}
		, xaxis:
		{
			categories: ["01 Jan", "02 Jan", "03 Jan", "04 Jan", "05 Jan", "06 Jan", "07 Jan", "08 Jan", "09 Jan", "10 Jan", "11 Jan", "12 Jan"]
		}
		, tooltip:
		{
			y: [
			{
				title:
				{
					formatter: function(e)
					{
						return e + " (mins)"
					}
				}
			}
			, {
				title:
				{
					formatter: function(e)
					{
						return e + " per session"
					}
				}
			}
			, {
				title:
				{
					formatter: function(e)
					{
						return e
					}
				}
			}]
		}
		, grid:
		{
			borderColor: "#f1f1f1"
		}
	}, (chart = new ApexCharts(document.querySelector("#line_chart_dashed"), options)).render()), getChartColorsArray("line_chart_annotations"));

function generateDayWiseTimeSeries(e, t, a)
{
	for (var r = 0, i = []; r < t;)
	{
		var n = e
			, o = Math.floor(Math.random() * (a.max - a.min + 1)) + a.min;
		i.push([n, o]), e += 864e5, r++
	}
	return i
}
linechartannotationsColors && (options = {
	series: [
	{
		data: series.monthDataSeries1.prices
	}]
	, chart:
	{
		height: 350
		, type: "line"
		, id: "areachart-2"
		, toolbar:
		{
			show: !1
		}
	}
	, annotations:
	{
		yaxis: [
		{
			y: 8200
			, borderColor: "#038edc"
			, label:
			{
				borderColor: "#038edc"
				, style:
				{
					color: "#fff"
					, background: "#038edc"
				}
				, text: "Support"
			}
		}
		, {
			y: 8600
			, y2: 9e3
			, borderColor: "#f7cc53"
			, fillColor: "#f7cc53"
			, opacity: .2
			, label:
			{
				borderColor: "#f7cc53"
				, style:
				{
					fontSize: "10px"
					, color: "#000"
					, background: "#f7cc53"
				}
				, text: "Y-axis range"
			}
		}]
		, xaxis: [
		{
			x: new Date("23 Nov 2017").getTime()
			, strokeDashArray: 0
			, borderColor: "#564ab1"
			, label:
			{
				borderColor: "#564ab1"
				, style:
				{
					color: "#fff"
					, background: "#564ab1"
				}
				, text: "Anno Test"
			}
		}
		, {
			x: new Date("26 Nov 2017").getTime()
			, x2: new Date("28 Nov 2017").getTime()
			, fillColor: "#51d28c"
			, opacity: .4
			, label:
			{
				borderColor: "#000"
				, style:
				{
					fontSize: "10px"
					, color: "#fff"
					, background: "#000"
				}
				, offsetY: -10
				, text: "X-axis range"
			}
		}]
		, points: [
		{
			x: new Date("01 Dec 2017").getTime()
			, y: 8607.55
			, marker:
			{
				size: 8
				, fillColor: "#fff"
				, strokeColor: "red"
				, radius: 2
				, cssClass: "apexcharts-custom-class"
			}
			, label:
			{
				borderColor: "#f34e4e"
				, offsetY: 0
				, style:
				{
					color: "#fff"
					, background: "#f34e4e"
				}
				, text: "Point Annotation"
			}
		}
		, {
			x: new Date("08 Dec 2017").getTime()
			, y: 9340.85
			, marker:
			{
				size: 0
			}
			, image:
			{
				path: "./assets/images/logo-sm.png"
				, width: 40
				, height: 40
			}
		}]
	}
	, dataLabels:
	{
		enabled: !1
	}
	, stroke:
	{
		curve: "straight"
	}
	, colors: linechartannotationsColors
	, grid:
	{
		padding:
		{
			right: 30
			, left: 20
		}
	}
	, title:
	{
		text: "Line with Annotations"
		, align: "left"
		, style:
		{
			fontWeight: 500
		}
	}
	, labels: series.monthDataSeries1.dates
	, xaxis:
	{
		type: "datetime"
	}
}, (chart = new ApexCharts(document.querySelector("#line_chart_annotations"), options)).render());
var chart, data = generateDayWiseTimeSeries(new Date("11 Feb 2017").getTime(), 185
	, {
		min: 30
		, max: 90
	})
	, brushchartLine2Colors = getChartColorsArray("brushchart_line2")
	, brushchartLineColors = (brushchartLine2Colors && (options = {
		series: [
		{
			data: data
		}]
		, chart:
		{
			id: "chart2"
			, type: "line"
			, height: 220
			, toolbar:
			{
				autoSelected: "pan"
				, show: !1
			}
		}
		, colors: brushchartLine2Colors
		, stroke:
		{
			width: 3
		}
		, dataLabels:
		{
			enabled: !1
		}
		, fill:
		{
			opacity: 1
		}
		, markers:
		{
			size: 0
		}
		, xaxis:
		{
			type: "datetime"
		}
	}, (chart = new ApexCharts(document.querySelector("#brushchart_line2"), options)).render()), getChartColorsArray("brushchart_line"))
	, steplineChartColors = (brushchartLineColors && (optionsLine = {
		series: [
		{
			data: data
		}]
		, chart:
		{
			id: "chart1"
			, height: 130
			, type: "area"
			, brush:
			{
				target: "chart2"
				, enabled: !0
			}
			, selection:
			{
				enabled: !0
				, xaxis:
				{
					min: new Date("19 Jun 2017").getTime()
					, max: new Date("14 Aug 2017").getTime()
				}
			}
		}
		, colors: brushchartLineColors
		, fill:
		{
			type: "gradient"
			, gradient:
			{
				opacityFrom: .91
				, opacityTo: .1
			}
		}
		, xaxis:
		{
			type: "datetime"
			, tooltip:
			{
				enabled: !1
			}
		}
		, yaxis:
		{
			tickAmount: 2
		}
	}, (chartLine = new ApexCharts(document.querySelector("#brushchart_line"), optionsLine)).render()), getChartColorsArray("line_chart_stepline"))
	, lineChartGradientColors = (steplineChartColors && (options = {
		series: [
		{
			data: [34, 44, 54, 21, 12, 43, 33, 23, 66, 66, 58]
		}]
		, chart:
		{
			type: "line"
			, height: 350
			, toolbar:
			{
				show: !1
			}
		}
		, stroke:
		{
			curve: "stepline"
		}
		, dataLabels:
		{
			enabled: !1
		}
		, title:
		{
			text: "Stepline Chart"
			, align: "left"
			, style:
			{
				fontWeight: 500
			}
		}
		, markers:
		{
			hover:
			{
				sizeOffset: 4
			}
		}
		, colors: steplineChartColors
	}, (chart = new ApexCharts(document.querySelector("#line_chart_stepline"), options)).render()), getChartColorsArray("line_chart_gradient"))
	, linechartMissingDataColors = (lineChartGradientColors && (options = {
		series: [
		{
			name: "Likes"
			, data: [4, 3, 10, 9, 29, 19, 22, 9, 12, 7, 19, 5, 13, 9, 17, 2, 7, 5]
		}]
		, chart:
		{
			height: 350
			, type: "line"
			, toolbar:
			{
				show: !1
			}
		}
		, stroke:
		{
			width: 7
			, curve: "smooth"
		}
		, xaxis:
		{
			type: "datetime"
			, categories: ["1/11/2001", "2/11/2001", "3/11/2001", "4/11/2001", "5/11/2001", "6/11/2001", "7/11/2001", "8/11/2001", "9/11/2001", "10/11/2001", "11/11/2001", "12/11/2001", "1/11/2002", "2/11/2002", "3/11/2002", "4/11/2002", "5/11/2002", "6/11/2002"]
			, tickAmount: 10
		}
		, title:
		{
			text: "Social Media"
			, align: "left"
			, style:
			{
				fontWeight: 500
			}
		}
		, fill:
		{
			type: "gradient"
			, gradient:
			{
				shade: "dark"
				, gradientToColors: lineChartGradientColors
				, shadeIntensity: 1
				, type: "horizontal"
				, opacityFrom: 1
				, opacityTo: 1
				, stops: [0, 100, 100, 100]
			}
		}
		, markers:
		{
			size: 4
			, colors: ["#038edc"]
			, strokeColors: "#fff"
			, strokeWidth: 2
			, hover:
			{
				size: 7
			}
		}
		, yaxis:
		{
			min: -10
			, max: 40
			, title:
			{
				text: "Engagement"
			}
		}
	}, (chart = new ApexCharts(document.querySelector("#line_chart_gradient"), options)).render()), getChartColorsArray("line_chart_missing_data"))
	, lastDate = (linechartMissingDataColors && (options = {
		series: [
		{
			name: "Peter"
			, data: [5, 5, 10, 8, 7, 5, 4, null, null, null, 10, 10, 7, 8, 6, 9]
		}
		, {
			name: "Johnny"
			, data: [10, 15, null, 12, null, 10, 12, 15, null, null, 12, null, 14, null, null, null]
		}
		, {
			name: "David"
			, data: [null, null, null, null, 3, 4, 1, 3, 4, 6, 7, 9, 5, null, null, null]
		}]
		, chart:
		{
			height: 350
			, type: "line"
			, zoom:
			{
				enabled: !1
			}
			, animations:
			{
				enabled: !1
			}
		}
		, stroke:
		{
			width: [5, 5, 4]
			, curve: "straight"
		}
		, labels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]
		, title:
		{
			text: "Missing data (null values)"
			, style:
			{
				fontWeight: 500
			}
		}
		, xaxis:
		{}
		, colors: linechartMissingDataColors
	}, (chart = new ApexCharts(document.querySelector("#line_chart_missing_data"), options)).render()), 0)
	, data = []
	, TICKINTERVAL = 864e5
	, XAXISRANGE = 7776e5;

function getDayWiseTimeSeries(e, t, a)
{
	for (var r = 0; r < t;)
	{
		var i = e
			, n = Math.floor(Math.random() * (a.max - a.min + 1)) + a.min;
		data.push(
		{
			x: i
			, y: n
		}), lastDate = e, e += TICKINTERVAL, r++
	}
}

function getNewSeries(e, t)
{
	var a = e + TICKINTERVAL;
	lastDate = a;
	for (var r = 0; r < data.length - 10; r++) data[r].x = a - XAXISRANGE - TICKINTERVAL, data[r].y = 0;
	data.push(
	{
		x: a
		, y: Math.floor(Math.random() * (t.max - t.min + 1)) + t.min
	})
}

function resetData()
{
	data = data.slice(data.length - 10, data.length)
}
getDayWiseTimeSeries(new Date("11 Feb 2017 GMT").getTime(), 10
, {
	min: 10
	, max: 90
});
var options, charts, linechartrealtimeColors = getChartColorsArray("line_chart_realtime");

function generateDayWiseTimeSeriesline(e, t, a)
{
	for (var r = 0, i = []; r < t;)
	{
		var n = e
			, o = Math.floor(Math.random() * (a.max - a.min + 1)) + a.min;
		i.push([n, o]), e += 864e5, r++
	}
	return i
}
linechartrealtimeColors && (options = {
	series: [
	{
		data: data.slice()
	}]
	, chart:
	{
		id: "realtime"
		, height: 350
		, type: "line"
		, animations:
		{
			enabled: !0
			, easing: "linear"
			, dynamicAnimation:
			{
				speed: 1e3
			}
		}
		, toolbar:
		{
			show: !1
		}
		, zoom:
		{
			enabled: !1
		}
	}
	, dataLabels:
	{
		enabled: !1
	}
	, stroke:
	{
		curve: "smooth"
	}
	, title:
	{
		text: "Dynamic Updating Chart"
		, align: "left"
		, style:
		{
			fontWeight: 500
		}
	}
	, markers:
	{
		size: 0
	}
	, colors: linechartrealtimeColors
	, xaxis:
	{
		type: "datetime"
		, range: XAXISRANGE
	}
	, yaxis:
	{
		max: 100
	}
	, legend:
	{
		show: !1
	}
}, (charts = new ApexCharts(document.querySelector("#line_chart_realtime"), options)).render()), window.setInterval(function()
{
	getNewSeries(lastDate
	, {
		min: 10
		, max: 90
	}), charts.updateSeries([
	{
		data: data
	}])
}, 1e3);
var optionsLine, chartLine, optionsLine2, chartLine2, optionsArea, chartArea, chartSyncingLine = getChartColorsArray("chart-syncing-line")
	, chartSyncingLine2 = (chartSyncingLine && (optionsLine = {
		series: [
		{
			data: generateDayWiseTimeSeriesline(new Date("11 Feb 2017").getTime(), 20
			, {
				min: 10
				, max: 60
			})
		}]
		, chart:
		{
			id: "fb"
			, group: "social"
			, type: "line"
			, height: 160
			, toolbar:
			{
				show: !1
			}
		}
		, colors: chartSyncingLine
		, dataLabels:
		{
			enabled: !1
		}
		, stroke:
		{
			curve: "straight"
			, width: 3
		}
		, toolbar:
		{
			tools:
			{
				selection: !1
			}
		}
		, markers:
		{
			size: 4
			, hover:
			{
				size: 6
			}
		}
		, tooltip:
		{
			followCursor: !1
			, x:
			{
				show: !1
			}
			, marker:
			{
				show: !1
			}
			, y:
			{
				title:
				{
					formatter: function()
					{
						return ""
					}
				}
			}
		}
		, grid:
		{
			clipMarkers: !1
		}
		, yaxis:
		{
			tickAmount: 2
		}
		, xaxis:
		{
			type: "datetime"
		}
	}, (chartLine = new ApexCharts(document.querySelector("#chart-syncing-line"), optionsLine)).render()), getChartColorsArray("chart-syncing-line2"))
	, chartSyncingArea = (chartSyncingLine2 && (optionsLine2 = {
		series: [
		{
			data: generateDayWiseTimeSeriesline(new Date("11 Feb 2017").getTime(), 20
			, {
				min: 10
				, max: 30
			})
		}]
		, chart:
		{
			id: "tw"
			, group: "social"
			, type: "line"
			, height: 160
			, toolbar:
			{
				show: !1
			}
		}
		, colors: chartSyncingLine2
		, dataLabels:
		{
			enabled: !1
		}
		, stroke:
		{
			curve: "straight"
			, width: 3
		}
		, toolbar:
		{
			tools:
			{
				selection: !1
			}
		}
		, markers:
		{
			size: 4
			, hover:
			{
				size: 6
			}
		}
		, tooltip:
		{
			followCursor: !1
			, x:
			{
				show: !1
			}
			, marker:
			{
				show: !1
			}
			, y:
			{
				title:
				{
					formatter: function()
					{
						return ""
					}
				}
			}
		}
		, grid:
		{
			clipMarkers: !1
		}
		, yaxis:
		{
			tickAmount: 2
		}
		, xaxis:
		{
			type: "datetime"
		}
	}, (chartLine2 = new ApexCharts(document.querySelector("#chart-syncing-line2"), optionsLine2)).render()), getChartColorsArray("chart-syncing-area"));
chartSyncingArea && (optionsArea = {
	series: [
	{
		data: generateDayWiseTimeSeriesline(new Date("11 Feb 2017").getTime(), 20
		, {
			min: 10
			, max: 60
		})
	}]
	, chart:
	{
		id: "yt"
		, group: "social"
		, type: "area"
		, height: 160
		, toolbar:
		{
			show: !1
		}
	}
	, colors: chartSyncingArea
	, dataLabels:
	{
		enabled: !1
	}
	, stroke:
	{
		curve: "straight"
		, width: 3
	}
	, toolbar:
	{
		tools:
		{
			selection: !1
		}
	}
	, markers:
	{
		size: 4
		, hover:
		{
			size: 6
		}
	}
	, tooltip:
	{
		followCursor: !1
		, x:
		{
			show: !1
		}
		, marker:
		{
			show: !1
		}
		, y:
		{
			title:
			{
				formatter: function()
				{
					return ""
				}
			}
		}
	}
	, grid:
	{
		clipMarkers: !1
	}
	, yaxis:
	{
		tickAmount: 2
	}
	, xaxis:
	{
		type: "datetime"
	}
}, (chartArea = new ApexCharts(document.querySelector("#chart-syncing-area"), optionsArea)).render());    
    
</script>
<?php include 'footer.php'; ?>