<?php include 'header.php'; ?>

<?php 
// Load Upwork credentials
$upworkCreds = null;
$stmt = $conn->prepare("SELECT * FROM upwork WHERE user_id = ? LIMIT 1");
$stmt->bind_param("s", $userId);
if ($stmt->execute()) {
    $res = $stmt->get_result();
    if ($res && $res->num_rows === 1) {
        $upworkCreds = $res->fetch_assoc();
    }
}
$stmt->close();

// Get greeting based on current hour
function getGreeting() {
    $currentHour = date('H');
    if ($currentHour >= 5 && $currentHour < 12) {
        return "Good morning";
    } else if ($currentHour >= 12 && $currentHour < 18) {
        return "Good afternoon";
    } else if ($currentHour >= 18 && $currentHour < 22) {
        return "Good evening";
    } else {
        return "Good night";
    }
}

$greeting = getGreeting();
?>

<div class="page-content">
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">
                    <h4 class="mb-sm-0">Profile</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Upwork</a></li>
                            <li class="breadcrumb-item active">Profile</li>
                        </ol>
                    </div>

                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="p-6 rounded-md text-black">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <h2 class="text-2xl font-semibold mb-3">
                                        <?php echo $greeting; ?> 
                                        <a href="#" id="profileLink" target="_blank" rel="noopener noreferrer" class="text-success text-decoration-underline">
                                            <span id="userName">Loading...</span>
                                        </a>
                                    </h2>
                                    <p class="font-medium text-muted mb-2" id="userTitle">Loading...</p>
                                    <p class="text-sm text-muted mb-3">Get started to rise on Upwork</p>

                                    <div class="mt-2 mb-3">
                                        <span class="px-2 py-1 rounded text-xs font-medium bg-success bg-opacity-10 text-success mb-0" id="connectsBadge" >
                                            Connects: <span id="connectsBalance">...</span>
                                        </span>
                                    </div>
                                   
                                </div>
                                <div class="flex-shrink-0">
                                    <img src="/user.png" alt="user" id="profileImage" class="w-24 h-24 object-cover rounded-circle" />
                                </div>
                            </div>
                        </div>


                        <!-- Error Message -->
                        <div id="errorMessage" class="alert alert-danger" style="display: none;">
                            <span id="errorText"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Pass data to JavaScript -->
<script>
const upworkCreds = <?php echo json_encode($upworkCreds); ?>;
</script>

<!-- Include profile.js -->
<script src="profilejs.php"></script>

<?php include 'footer.php'; ?>