<?php include 'header.php'; ?>
<?php
$msg = '';

// Helpers
function to_json($value) {
    if (is_array($value)) {
        return json_encode(array_values($value));
    }
    if (is_string($value)) {
        return $value;
    }
    return json_encode([]);
}

// Load existing settings
$settings = null;
$stmt = $conn->prepare("SELECT * FROM upwork_settings WHERE user_id = ? LIMIT 1");
$stmt->bind_param("s", $userId);
if ($stmt->execute()) {
    $res = $stmt->get_result();
    if ($res && $res->num_rows === 1) {
        $settings = $res->fetch_assoc();
    }
}
$stmt->close();

// Defaults
$default_job_type = ["hourly", "fixed"];
$default_contractor_tier = ["EntryLevel", "IntermediateLevel", "ExpertLevel"];
$default_workload = ["full_time", "part_time", "as_needed"];
$default_duration = ["semester", "ongoing", "month", "week"];
$default_hourly_rates = "0-100";
$default_search = "web";
$default_min = "0";
$default_max = "100";

// Current values
$current_job_type = $default_job_type;
if ($settings && !empty($settings['job_type'])) { $dec = json_decode($settings['job_type'], true); if (is_array($dec)) { $current_job_type = $dec; } }
$current_contractor_tier = $default_contractor_tier;
if ($settings && !empty($settings['contractor_tier'])) { $dec = json_decode($settings['contractor_tier'], true); if (is_array($dec)) { $current_contractor_tier = $dec; } }
$current_workload = $default_workload;
if ($settings && !empty($settings['workload'])) { $dec = json_decode($settings['workload'], true); if (is_array($dec)) { $current_workload = $dec; } }
$current_duration = $default_duration;
if ($settings && !empty($settings['duration'])) { $dec = json_decode($settings['duration'], true); if (is_array($dec)) { $current_duration = $dec; } }
$current_hourly_rates = ($settings && isset($settings['hourly_rates']) && $settings['hourly_rates'] !== '') ? (string)$settings['hourly_rates'] : $default_hourly_rates;
$current_search = ($settings && isset($settings['search']) && $settings['search'] !== '') ? (string)$settings['search'] : $default_search;
$current_min = explode('-', $current_hourly_rates)[0];
$current_max = explode('-', $current_hourly_rates)[1] ?? $default_max;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Arrays
    $job_type = isset($_POST['job_type']) && is_array($_POST['job_type']) ? array_values($_POST['job_type']) : [];
    $contractor_tier = isset($_POST['contractor_tier']) && is_array($_POST['contractor_tier']) ? array_values($_POST['contractor_tier']) : [];
    $workload = isset($_POST['workload']) && is_array($_POST['workload']) ? array_values($_POST['workload']) : [];
    $duration = isset($_POST['duration']) && is_array($_POST['duration']) ? array_values($_POST['duration']) : [];
    // Scalars
    $search = isset($_POST['search']) ? trim($_POST['search']) : $default_search;
    $min = isset($_POST['min']) ? trim($_POST['min']) : $default_min;
    $max = isset($_POST['max']) ? trim($_POST['max']) : $default_max;

    // Compose hourly_rates
    $min_val = (is_numeric($min) ? (int)$min : (int)$default_min);
    $max_val = (is_numeric($max) ? (int)$max : (int)$default_max);
    if ($min_val < 0) { $min_val = 0; }
    if ($max_val < $min_val) { $max_val = $min_val; }
    $hourly_rates = $min_val . '-' . $max_val;

    if ($settings) {
        $query = "UPDATE upwork_settings SET job_type = ?, contractor_tier = ?, workload = ?, duration = ?, hourly_rates = ?, search = ?, updated_at = NOW() WHERE user_id = ?";
$stmt = $conn->prepare($query);
$jt = to_json($job_type);
$ct = to_json($contractor_tier);
$wl = to_json($workload);
$du = to_json($duration);
$min_str = (string)$min_val;
$max_str = (string)$max_val;
        $stmt->bind_param(
            "sssssss",
            $jt,
            $ct,
            $wl,
            $du,
            $hourly_rates,
            $search,
            $userId
        );
        if ($stmt->execute()) {
            $msg = '<div class="alert alert-success alert-top-border alert-dismissible fade show" role="alert">
                        <i class="ri-check-double-line me-3 align-middle fs-16 text-success"></i><strong>Success</strong> - Settings updated
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>';
            $current_job_type = $job_type;
            $current_contractor_tier = $contractor_tier;
            $current_workload = $workload;
            $current_duration = $duration;
            $current_hourly_rates = $hourly_rates;
            $current_search = $search;
            $current_min = (string)$min_val;
            $current_max = (string)$max_val;
        } else {
            $msg = '<div class="alert alert-danger alert-top-border alert-dismissible fade show" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16 text-danger"></i><strong>Error</strong> - Failed to update settings
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>';
        }
        $stmt->close();
    } else {
        $query = "INSERT INTO upwork_settings (user_id, job_type, contractor_tier, workload, duration, hourly_rates, search, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())";
        $stmt = $conn->prepare($query);
        $jt = to_json($job_type);
        $ct = to_json($contractor_tier);
        $wl = to_json($workload);
        $du = to_json($duration);
        $stmt->bind_param("sssssss", $userId, $jt, $ct, $wl, $du, $hourly_rates, $search);
        if ($stmt->execute()) {
            $msg = '<div class="alert alert-success alert-top-border alert-dismissible fade show" role="alert">
                        <i class="ri-check-double-line me-3 align-middle fs-16 text-success"></i><strong>Success</strong> - Settings saved
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>';
            $current_job_type = $job_type;
            $current_contractor_tier = $contractor_tier;
            $current_workload = $workload;
            $current_duration = $duration;
            $current_hourly_rates = $hourly_rates;
            $current_search = $search;
            $current_min = (string)$min_val;
            $current_max = (string)$max_val;
        } else {
            $msg = '<div class="alert alert-danger alert-top-border alert-dismissible fade show" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16 text-danger"></i><strong>Error</strong> - Failed to save settings
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>';
        }
        $stmt->close();
    }
}
?>

<div class="page-content">
    <div class="container-fluid">

        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-transparent">
                    <h4 class="mb-sm-0">Upwork Filters</h4>
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                            <li class="breadcrumb-item active">Settings</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

        <center>
            <div class="col-lg-8">
                <?php echo $msg; ?>

                <div class="card card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar-xl me-3">
                            <div class="avatar-title bg-transparent text-primary rounded" style="font-size: 60px">
                                <i class="ri-filter-3-line"></i>
                            </div>
                        </div>
                        <div>
                            <h2 class="mb-0">Upwork Filters</h2>
                            <p class="text-muted mb-0">Configure search filters for Upwork job discovery.</p>
                        </div>
                    </div>

                    <form method="POST" class="p-2">
                        <div class="row g-3 text-start">
                            <div class="col-12">
                                <label class="form-label" for="search">Search Keyword</label>
                                <input type="text" class="form-control" id="search" name="search" value="<?php echo htmlspecialchars($current_search); ?>" placeholder="Search...">
                            </div>

                            <div class="col-12 col-md-4">
                                <label class="form-label">Job Type</label>
                                <div class="row g-2">
                                    <?php foreach (["hourly", "fixed"] as $type) { $checked = in_array($type, $current_job_type); ?>
                                    <div class="col-12">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="job_<?php echo $type; ?>" name="job_type[]" value="<?php echo $type; ?>" <?php echo $checked ? 'checked' : '' ; ?>>
                                            <label class="form-check-label" for="job_<?php echo $type; ?>"><?php echo $type === 'hourly' ? 'Hourly' : 'Fixed'; ?></label>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Work Tier</label>
                                <div class="row g-2">
                                    <?php foreach (["EntryLevel", "IntermediateLevel", "ExpertLevel"] as $tier) { $checked = in_array($tier, $current_contractor_tier); ?>
                                    <div class="col-12 col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="tier_<?php echo md5($tier); ?>" name="contractor_tier[]" value="<?php echo $tier; ?>" <?php echo $checked ? 'checked' : '' ; ?>>
                                            <label class="form-check-label" for="tier_<?php echo md5($tier); ?>"><?php echo ($tier === 'EntryLevel' ? 'Entry Level' : ($tier === 'IntermediateLevel' ? 'Intermediate Level' : 'Expert Level')); ?></label>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Workload</label>
                                <div class="row g-2">
                                    <?php foreach (["as_needed", "part_time", "full_time"] as $load) { $checked = in_array($load, $current_workload); ?>
                                    <div class="col-12 col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="load_<?php echo md5($load); ?>" name="workload[]" value="<?php echo $load; ?>" <?php echo $checked ? 'checked' : '' ; ?>>
                                            <label class="form-check-label" for="load_<?php echo md5($load); ?>"><?php echo ($load === 'as_needed' ? 'As Needed' : ($load === 'part_time' ? 'Part Time' : 'Full Time')); ?></label>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>

                            <div class="col-12">
                                <label class="form-label">Duration</label>
                                <div class="row g-2">
                                    <?php foreach (["week", "month", "semester", "ongoing"] as $duration) { $checked = in_array($duration, $current_duration); ?>
                                    <div class="col-12 col-md-6">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox" id="duration_<?php echo md5($duration); ?>" name="duration[]" value="<?php echo $duration; ?>" <?php echo $checked ? 'checked' : '' ; ?>>
                                            <label class="form-check-label" for="duration_<?php echo md5($duration); ?>"><?php echo ucfirst($duration); ?></label>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>

                            <?php $parts = explode('-', $current_hourly_rates . '-'); $hr_min = $parts[0]; $hr_max = $parts[1] ?? ''; ?>
                            <div class="col-12">
                                <label class="form-label">Hourly Rate</label>
                                <div class="row g-2">
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="min">Minimum Hourly Rate</label>
                                        <input type="number" class="form-control" id="min" name="min" value="<?php echo htmlspecialchars((string)$hr_min); ?>" placeholder="0">
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="max">Maximum Hourly Rate</label>
                                        <input type="number" class="form-control" id="max" name="max" value="<?php echo htmlspecialchars((string)$hr_max); ?>" placeholder="100">
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <button type="submit" class="btn btn-success w-100">Save settings</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </center>
    </div>

    <?php include 'footer.php'; ?>


